// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 

#declare C_clear  =         rgbt 1 ;
#declare C_white =          color rgb <1,1,1>  ;
#declare C_black =          color rgb <0,0,0>  ;
#declare C_gray_dark =      color rgb <0.07,0.07,0.07> ;
#declare C_gray_black =     color rgb <0.03,0.03,0.03>  ;
#declare C_red =            color rgb <1,0,0>  ;  
#declare C_red_dark =       color rgb <.5,0,0>  ; 
#declare C_maroon =         color rgb <.45,.02,.02>  ;
#declare C_green =          color rgb <0,1,0>  ;  
#declare C_yellow =         color rgb <1,.9,0>  ;
#declare C_blue =           color rgb <0,.5,.9>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_rust_red =       color rgb <0.6, 0.3, 0.25> ;
#declare C_rust_red_film =  color rgbt <0.6, 0.3, 0.25,.5> ;
#declare C_rust_gray =      color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_gray_dark = color rgb <0.70, 0.70, 0.80>  ; 
#declare C_galvanize1 =     color rgb <0.90, 0.90, 0.95> ;
#declare C_galvanize2 =     color rgb <0.80, 0.80, 0.85>  ;
#declare C_breaker_black =  color rgb <0.15,.15,.17> *.3 ;
#declare C_panel_gray =     color rgb <0.15,.15,.17> * 2 ;
#declare C_gray_blue =      color red 0.8 green 0.8 blue 0.9 ;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;
#declare C_orange =         color rgb <1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color rgb <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_blue_charcoal =  color rgb <.07,.09,.18> ;
#declare C_yellow_dull  =   color rgb <1,.9,.10>  ;
#declare C_sea_green =      color rgb <.4,1,.6> ;
#declare f = .0039  ;                             
#declare tR = 107*f ;
#declare tG = 176*f ;
#declare tB = 189*f ;
#declare C_teal = color rgb<tR,tG,tB> ;
#declare C_red50 = rgbf<1,0,0,.5>;

// -----------------------------------------------------------------------------------------
//                      I N T E R I O R S
//------------------------------------------------------------------------------------------

#declare I_white=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

 #declare I_clear=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

#declare I_dark=
  interior {
    ior 1.5  
    fade_colour <.5,.5,.5>
    fade_distance 1.0
    fade_power .2
  }
  
#declare I_green =
    interior {
        ior 1.6
        fade_colour <0,.7,.2>
        fade_distance .5
        fade_power 2
        }  
        
#declare I_green_light =
    interior {
        ior 1.6
        fade_colour <.75,1,.9>
        fade_distance .5
        fade_power 2
        }        

#declare I_blue =
    interior {
        ior 1.6
        fade_colour <0,.8,1>
        fade_distance .5
        fade_power 2
        }
 
#declare I_blue_dark =
    interior {
        ior 1.6
        fade_colour <.1,.3,.5>
        fade_distance .5
        fade_power 2
        }
        
#declare I_red =
    interior {
        ior 1.6
        fade_colour <1,0,0>
        fade_distance .5
        fade_power 2
        }  


#declare I_gold =
    interior {
        ior 1.6
        fade_colour <0.90, 0.65, 0.15>
        fade_distance .5
        fade_power 2
        } 
        
        
#declare I_solid =
    interior {
        ior 1
        fade_colour <0,0,0>
        fade_distance 0
        fade_power 0
        }      

#declare I_glass =  interior { ior 1.33 }


// -----------------------------------------------------------------------------------------
//                      N O R M A L S 
//------------------------------------------------------------------------------------------   
#declare N_ripple_A =       normal { bozo 0.2 scale 0.2 bump_size 2}  
#declare N_ripple_large =   normal{ N_ripple_A scale 10 bump_size 5}
#declare N_small_bumps =    normal { leopard bump_size 10 scale 1 warp { turbulence 1 }}
#declare N_granite =        normal { granite 1 bump_size 1 scale 1 warp { turbulence .5 }} 
#declare N_leopard =        normal { leopard bump_size 9 scale .5 warp { turbulence 6 }} 
#declare N_mud_bozo =       normal { bozo bump_size 5 scale 1 warp { turbulence 3 }} 
#declare N_mud_wrinkles =   normal { wrinkles bump_size 2 scale 1 warp { turbulence 3 }} 
#declare N_crackle =        normal { crackle bump_size .1 scale 1 warp { turbulence 1 }}  
#declare N_mud_agate =      normal { agate bump_size 2 scale 1 warp { turbulence 1 }} 

#declare N_crackle_A =
normal { 
    pigment_pattern{ 
        crackle 
        turbulence 0.2
        colour_map {[0.00, rgb 0]
                    [0.25, rgb 1]
                    [0.95, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_leopard_A =
normal { 
    pigment_pattern{ 
        leopard 
        turbulence 0.2
        colour_map {[0.00, rgb 0] 
                    [0.5, rgb 0]
                    [0.6, rgb 1]
                    [0.9, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_granite_A =
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.5, rgb 1]
                    [0.7, rgb 0]
                    [0.9, rgb 0]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
} 

#declare N_dent_A =  
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.4, rgb 1]
                    [0.5, rgb 0]
                    [0.8, rgb 0]
                    [0.9, rgb 1]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
}
 
// -----------------------------------------------------------------------------------------
//                      F I N I S H E S
//------------------------------------------------------------------------------------------

#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .3
    phong_size 5  
}

#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}
      
#declare F_satin =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 40  
}

#declare F_dull =
finish {
    ambient .2
    diffuse 1   
    phong .1
    phong_size 10  
}

#declare F_glass =
  finish {
    specular 0.7
    roughness 0.001
    ambient .5
    diffuse .5
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
#declare F_glass_dark =
  finish {
    specular .02
    roughness 0.01   
    phong 1     
    phong_size 100  
    ambient .5
    diffuse 0
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
  #declare F_hazy_glass =
     finish {
     reflection {0, .85 fresnel on } 
     conserve_energy
     phong 10     
     phong_size 60   
     metallic 1
     specular 30 
     roughness 1/10 
    }

  #declare F_hard_glass =
     finish {
     reflection {.2, 1 fresnel on } 
     conserve_energy
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
    }

  #declare F_milky =
     finish {
     reflection {.4, .6 fresnel on } 
     conserve_energy
     phong 1     
     phong_size 60   
     metallic 0
     specular .2 
     roughness 1/10 
    }

// -----------------------------------------------------------------------------------------
//                      T E X T U R E S
//------------------------------------------------------------------------------------------ 

#declare P_clear_black =    pigment { color C_black transmit 1 }
#declare P_clear_white =    pigment { color C_white transmit 1 }       
#declare T_clear_black =    texture{ pigment{ P_clear_black         }}  
#declare T_clear_white =    texture{ pigment{ P_clear_white         }}
#declare T_red_transmit =   texture{ pigment{ rgb C_red transmit 1  }} 
#declare T_gold =           texture{ pigment{ rgb C_gold            }} 
#declare T_gold_bright =    texture{ pigment{ rgb C_gold_bright     }} 


// -----------------------------------------------------------------------------------------
//                      W O O D
//------------------------------------------------------------------------------------------  
#declare CM_Wood_A =
color_map {
    [0.00 color rgb <0.3, 0.1, 0.03>  * .55]
    [0.30 color rgb <.8, 0.27, 0.1>  * .35]
    [0.60 color rgb <.8, 0.27, 0.1> * .35]
    [1.00 color rgb <0.3, 0.1, 0.03>  * .55]
}  


#declare CM_Wood_A_overlay =
color_map {
    [0.00 color rgbt <0.3, 0.1, 0.03, .3> ]
    [0.30 color rgbt <.8, 0.27, 0.1, .9>  ]
    [0.60 color rgbt <.8, 0.27, 0.1, .9>  ]
    [1.00 color rgbt <0.3, 0.1, 0.03, .3> ]
} 
  
#declare CM_Wood_A_bump =
color_map {
    [0.00 rgb 0]
    [0.30 rgb 1]
    [0.60 rgb 1]
    [1.00 rgb 0]
}   


#declare F_dull =
finish {
    ambient .2
    diffuse 1   
    phong .1
    phong_size 10  
}
    
#declare M_wood_handle = material{ 

    texture{ 
        pigment {
            wood
            turbulence 0.15
            omega 0.5
            lambda 2
            color_map { CM_Wood_A }
            rotate <40,0,0>
        } 
        finish {F_dull}
        normal { 
            pigment_pattern{ 
                wood
                turbulence 0.15
                omega 0.5
                lambda 2
                color_map { CM_Wood_A_bump } 
                rotate <40,0,0>
             } 
             bump_size .05
        }
     scale<.5,3,.5> *.5    
    } 

    texture{ 
        pigment {
            wood
            turbulence 0.15
            omega 0.5
            lambda 2
            color_map { CM_Wood_A_overlay }
            rotate <40,0,0>
        } 

        
     scale<.5,3,.5> *2    
    } 

 }

// -----------------------------------------------------------------------------------------
//                      S T E E L
//------------------------------------------------------------------------------------------

#declare C_map_old_copper =
color_map {
    [ 0.0  C_copper *.83]  
    [ 0.3  C_copper *.83]
    [ 0.5  C_gray60 *.63]
    [ 0.8  C_copper *.63] 
    [ 1    C_copper *.83]
    }
        
#declare C_map_rust_gray = 
color_map {
    [0.0        C_rust_gray* .3]
    [0.1        C_rust_gray_dark * 1]
    [0.3        C_rust_gray_dark * 1] 
    [0.55       C_rust_gray * .5]
    [0.85       C_rust_gray * .3]
    [0.9        C_rust_gray_dark * 1]
    [1.000      C_rust_gray* .5]
}


#declare C_map_rust_red = 
color_map {
    [0.0        C_rust_gray ]
    [0.2        C_rust_red * .5]
    [0.25       C_rust_red * .7] 
    [0.4        C_rust_gray * 1]
    [0.85       C_rust_gray * 1.5]
    [0.9        C_rust_red * .6]
    [1.000      C_rust_gray]
}


#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red ]
    [0.3        C_rust_red_film * .7] 
    [0.4        C_clear * 1]
    [0.85       C_clear * 1.5]
    [0.9        C_rust_red_film * .6]
    [1.000      C_clear]
}

#declare C_map_dirt_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_black ]
    [0.3        C_gray20 ] 
    [0.5        C_tan * .2]
    [0.85       C_clear ]
    [0.9        C_rust_red * .6]
    [1.000      C_black]
}



#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_gray70 ] 
    [0.4        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}

    
#declare C_map_dent_A = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_black ] 
    [0.4        C_black ]     
    [0.5        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}



#declare F_old_steel  =
finish {  
    reflection {.001, .2 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .8 
    metallic
    specular 3 
    roughness .1
    reflection .25 
}

//--- steel old
#declare sz = <.6,2,.6> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_gray} 
        turbulence turb
        scale sz
        } 


    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }



//--- steel old spotted
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .2; 

#declare T_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_old_steel}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


#declare M_steel_aged_2 =
material {
   texture { T_steel_old        rotate <30,30,30> scale <3,3,3>}
   texture { T_steel_spotted    rotate <30,30,30> scale <3,2,3>}
}

// -----------------------------------------------------------------------------------------
//                      G L A S S
//------------------------------------------------------------------------------------------
#declare M_glass =                      material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_clear} }  
#declare M_glass_dark =                 material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_dark} }
#declare M_glass_red =                  material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_red} }
#declare M_glass_gold =                 material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_gold} }
#declare M_glass_green =                material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_green} }
#declare M_glass_green_light =          material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_green_light} }
#declare M_glass_blue =                 material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_blue} }
#declare M_glass_blue_dark =            material{ texture{ T_clear_black    finish{F_hard_glass}}   interior{I_blue_dark} }




// -----------------------------------------------------------------------------------------
//                      S O L I D   C O L O R   M A T E R I A L S
//------------------------------------------------------------------------------------------
#declare M_gold_gloss =             material { texture {  pigment { C_gold }            finish { F_gloss    }}}
#declare M_red_gloss =              material { texture {  pigment { C_red }             finish { F_gloss    }}}
#declare M_red_dark_gloss =         material { texture {  pigment { C_red_dark*.75 }    finish { F_gloss    }}}
#declare M_yellow_gloss =           material { texture {  pigment { C_yellow }          finish { F_gloss    }}}
#declare M_yellow_dull =            material { texture {  pigment { C_yellow_dull }     finish { F_dull     }}}
#declare M_blue_gloss =             material { texture {  pigment { C_blue }            finish { F_gloss    }}}
#declare M_blue_charcoal_gloss =    material { texture {  pigment { C_blue_charcoal }   finish { F_gloss    }}}
#declare M_sea_green_gloss =        material { texture {  pigment { C_sea_green }       finish { F_gloss    }}}
#declare M_black_gloss =            material { texture {  pigment { C_black }           finish { F_gloss    }}}
#declare M_sg_maroon_gloss =        material { texture {  pigment { C_maroon }          finish { F_gloss    }}}
#declare M_black_rubber =           material { texture {  pigment { C_black }           finish { F_rubber   }}}
#declare M_black_dull =             material { texture {  pigment { C_black }           finish { F_dull     }}}
#declare M_gray_dark_dull =         material { texture {  pigment { C_gray_dark }       finish { F_dull     }}}
#declare M_red_rubber =             material { texture {  pigment { C_red }             finish { F_rubber   }}}
#declare M_black_rubber_grip =      material { texture {  pigment { C_gray_black    }   finish { F_rubber   } normal  { N_ripple_A }}}